/* 
 * sem.h
 *
 * Заголовочний файл із оголошеннями обгорток для операцій із семафорами
 * System V (реалізованих у файлі sem.c).
 *
 */

#ifndef SEM_H
#define SEM_H

/* Зменшує значення семафора System V, заданого дескриптором semd і
   номером number, на 1 у блокуючому режимі. */
extern int sem_down(int semd, int number);
/* Зменшує значення семафора System V, заданого дескриптором semd і
   номером number, на 1 в неблокуючому режимі. */
extern int sem_trydown(int semd, int number);
/* Збільшує значення семафора System V, заданого дескриптором semd і
   номером number, на 1. */
extern int sem_up(int semd, int number);

#endif /* SEM_H */
